from bpy.types import Operator
from ....libs.functions.get_common_vars import get_common_vars


class FLUIDLAB_OT_pretty_viewport(Operator):
    bl_idname = "fluidlab.pretty_viewport"
    bl_label = "Switcher Viewport"
    bl_description = "Switch Viewport"
    bl_options = {'REGISTER', 'UNDO'}


    def execute(self, context):

        rendering_props = get_common_vars(context, get_rendering=True)
        
        space_data = context.space_data

        areas = [area for area in context.screen.areas if area.type == 'VIEW_3D']
        view3d_spaces = [space for area in areas for space in area.spaces if space.type == 'VIEW_3D']

        if not rendering_props.viewport_switched:

            # Guardamos los valores previos del usuario, y seteamos el Pretty Viewport:

            for space in view3d_spaces: 

                rendering_props.last_show_overlays = space.overlay.show_overlays
                space.overlay.show_overlays = False

                rendering_props.last_background_type = space.shading.background_type
                space.shading.background_type = 'VIEWPORT'
                
                rendering_props.last_background_color = space.shading.background_color
                space.shading.background_color = (0.0, 0.0, 0.0)

                rendering_props.last_light_type = space.shading.light
                space.shading.light = 'STUDIO'

                rendering_props.last_color_type = space.shading.color_type 
                space.shading.color_type = 'MATERIAL'

                rendering_props.last_show_cavity = space.shading.show_cavity
                space.shading.show_cavity = True

                rendering_props.last_cavity_type = space.shading.cavity_type
                space.shading.cavity_type = 'BOTH'

                rendering_props.last_cavity_ridge_factor = space.shading.cavity_ridge_factor
                space.shading.cavity_ridge_factor = 0.5

                rendering_props.last_curvature_ridge_factor = space.shading.curvature_ridge_factor
                space.shading.curvature_ridge_factor = 0.5

                rendering_props.last_cavity_valley_factor = space.shading.cavity_valley_factor
                space.shading.cavity_valley_factor = 1.5

                rendering_props.last_curvature_valley_factor = space.shading.curvature_valley_factor
                space.shading.curvature_valley_factor = 0

                rendering_props.last_show_shadows = space.shading.show_shadows
                space.shading.show_shadows = True

            rendering_props.viewport_switched = True

        else:
            
            # Restauramos a lo que tuviera el usuario:

            for space in view3d_spaces:
                space.overlay.show_overlays = rendering_props.last_show_overlays
                space.shading.background_type = rendering_props.last_background_type
                space.shading.background_color = rendering_props.last_background_color
                space.shading.light = rendering_props.last_light_type
                space.shading.color_type = rendering_props.last_color_type 
                space.shading.show_cavity = rendering_props.last_show_cavity
                space.shading.cavity_type = rendering_props.last_cavity_type
                space.shading.cavity_ridge_factor = rendering_props.last_cavity_ridge_factor
                space.shading.curvature_ridge_factor = rendering_props.last_curvature_ridge_factor
                space.shading.cavity_valley_factor = rendering_props.last_cavity_valley_factor
                space.shading.curvature_valley_factor = rendering_props.last_curvature_valley_factor
                space.shading.show_shadows = rendering_props.last_show_shadows

            rendering_props.viewport_switched = False

        return {'FINISHED'}
